package extension.file;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class LogWriter {
	FileOutputStream logFile = null;
	/**
	 * コンストラクタ ログファイルのパスが必要
	 * @param logFilePath
	 */
	public LogWriter(String logFilePath){
		try {
			logFile = new FileOutputStream(logFilePath);
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		}
	}
	/**
	 * ログファイルの開放
	 */
	public void close() {
		try {
			logFile.close();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		logFile = null;
	}

	/**
	 * ログ出力（テキスト）
	 * @param str
	 */
	public void logWriteStr(String str) {
		if(logFile != null) {
			try {
				logFile.write((str + "\r\n").getBytes());
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.err.println("logFile is null");
		}
	}
	/**
	 * ログ出力（バイトのリスト）
	 * @param byteList
	 */
	public void logWriteByteList(ArrayList<byte[]> byteList) {
		if(logFile != null) {
			if(byteList == null) {
				System.err.println("byteList is null");
				return;
			}
			if(byteList.size() == 0) {
				byte[] outBuff = "byteList.size=0\r\n".getBytes();
				byteList.add(outBuff);
			}
			try {
				for(byte[] b: byteList) {
					logFile.write(b);
				}
				logFile.write("\r\n".getBytes());
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.err.println("logFile is null");
		}
	}
	/**
	 * ログ出力（文字列のリスト型）
	 * @param list
	 */
	public void logWriteStrList(ArrayList<String> list) {
		if(logFile != null) {
			try {
				for(String str:list) {
					logFile.write((str + "\r\n").getBytes());
				}
				logFile.write("\r\n".getBytes());
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
			System.err.println("logFile is null");
		}
	}
}
